SPRITES = {}

sprites = {}

local basicSprites = {
	"arrow",
	"bolt",
	"bullet",
	"circle",
	"circleOutline",
	"halfCircle",
	"halfCircleOutline",
	"line",
	"plus",
	"poly5",
	"poly6",
	"shadow",
	"shield",
	"square",
	"squareOutline",
	"star",
	"star6",
	"tile",
	"triangle",
	"triangleOutline",
}

local ingameSprites = {
	"sky",
	"star_1",
	"logo",
	"hud_ally",
	"hud_altometerBig",
	"hud_altometerSmall",
	"hud_box",
	"hud_danger",
	"hud_enemy",
	"hud_incomingNuke",
	"hud_nukeComplete",
	"hud_nukeLeft",
	"hud_nukeRight",
	"hud_nukeTriangle",
	"hud_pullUp",
}

function sprites.init()
	for index, spr in pairs(basicSprites) do
		SPRITES[spr] = video.createSpriteState(spr, "basic.dat")
	end

	for index, spr in pairs(ingameSprites) do
		SPRITES[spr] = video.createSpriteState(spr, "ingameGFX.dat")
		--print(SPRITES[spr], spr, "load", "ingameGFX.dat")
	end
	sprites.loadDefs(SHIP_TYPES, "ingameGFX.dat")
	sprites.loadDefs(PROJECTILE_TYPES, "ingameGFX.dat")
	sprites.loadDefs(MISSILE_TYPES, "ingameGFX.dat")
	sprites.loadDefs(FX_TYPES, "ingameGFX.dat")
	sprites.loadDefs(ASTEROID_TYPES, "ingameGFX.dat")
	sprites.loadDefs(RESOURCE_TYPES, "ingameGFX.dat")

	sprites.loadDef(Building, "ingameGFX.dat")
	sprites.loadDef(MissileSilo, "ingameGFX.dat")
	sprites.loadDef(Battery, "ingameGFX.dat")
	sprites.loadDef(StarPort, "ingameGFX.dat")
	sprites.loadDef(ShieldGenerator, "ingameGFX.dat")
	sprites.loadDef(Nexus, "ingameGFX.dat")
	sprites.loadDef(Shield, "ingameGFX.dat")
end


function sprites.loadDefs(defs, dat)
	for index, def in ipairs(defs) do
		sprites.loadDef(def, dat)
	end
end

function sprites.loadDef(def, dat)
	if def.spriteNames then
		def.sprites = {}
		for index, spriteNames in pairs(def.spriteNames) do
			local sprite = video.createSpriteState(spriteNames, dat)
			if type(index) == "number" then
				table.insert(def.sprites, sprite)
			else
				def.sprites[index] = sprite
			end
			--print(def.sprites[index], index, "load", spriteNames, dat)
		end
	end
end